<?php

class SWAP_TO_Settings
{

    private static $typography_fonts = array();
    private static $themeOptions = array();

    function __construct()
    {
        self::swap_to_get_settings();
        self::set_typography_fonts();

        add_action('admin_menu', array($this, 'swap_to_settings_page'), 1000);
        add_action('wp_ajax_swap_save_settings', array($this, 'swap_save_settings'));

        add_action('wp_ajax_swap_get_settings', array($this, 'get_settings'));

        add_action('wp_enqueue_scripts', array($this, 'swap_enqueue_custom_fonts'), 160);
        add_action('wp_enqueue_scripts', array($this, 'swap_enqueue_typography_css'), 200);


    }

  

    function swap_to_settings_page()
    {
        add_menu_page(
            'Theme Options',
            'Theme Options',
            'manage_options',
            'swap-to-settings',
            array($this, 'swap_to_settings_page_view'),
            'dashicons-admin-tools',
            5
        );
    }

    public static function swap_get_post_type_array($post_type, $args = array())
    {
        $r = array(
            '' => esc_html__('Choose Page', 'swap_theme_options'),
        );

        $default_args = array(
            'post_type' => $post_type,
            'posts_per_page' => -1,
            'post_status' => 'publish'
        );

        $q = get_posts(wp_parse_args($args, $default_args));

        if (!empty($q)) {
            foreach ($q as $post_data) {
                $r[$post_data->ID] = $post_data->post_title;
            }
        }

        wp_reset_query();

        return $r;
    }
    function swap_to_settings()
    {
        global $wp_registered_sidebars;
        $sidebars = array('' => esc_html__('Select Sidebar', 'swap_theme_options'));
        $sidebarPosition = array(
            'no_sidebar' => esc_html__('Without Sidebar', 'swap_theme_options'),
            'left' => esc_html__('Left', 'swap_theme_options'),
            'right' => esc_html__('Right', 'swap_theme_options')
        );

        $banners = $this->swap_get_post_type_array('swap-banners');
        foreach ($wp_registered_sidebars as $k => $val) {
            $sidebars[$val['id']] = $val['name'];
        }

        $columns = array(
            '12' => '100%',
            '9' => '75%',
            '6' => '50%',
            '4' => '33.3%',
            '3' => '25%',
            '2' => '16.6%',
        );

        return apply_filters('swap_to_settings', array(
            'id' => 'swap_to_settings',
            'args' => array(
                'swap_to_settings' => array(
                    'section_1' => array(
                        'name' => esc_html__('General', 'swap_theme_options'),
                        'fields' => array(
                           
                          'caption' => array(
                                'type' => 'text',
                                'label' => esc_html__('Caption', 'swap_theme_options'),
                            ),
                             
                          'about' => array(
                                'type' => 'textarea',
                                'label' => esc_html__('About', 'swap_theme_options'),
                            ),
                        
                            'phone_1' => array(
                                'type' => 'text',
                                'label' => esc_html__('Phone 1', 'swap_theme_options'),
                            ),
                            'phone_2' => array(
                                'type' => 'text',
                                'label' => esc_html__('Phone 2', 'swap_theme_options'),
                            ),
                             'phone_3' => array(
                                'type' => 'text',
                                'label' => esc_html__('Phone 3', 'swap_theme_options'),
                            ),
                              'whatsapp_1' => array(
                                'type' => 'text',
                                'label' => esc_html__('Whatsapp 1', 'swap_theme_options'),
                            ),
                              'whatsapp_2' => array(
                                'type' => 'text',
                                'label' => esc_html__('Whatsapp 2', 'swap_theme_options'),
                            ),
                              'whatsapp_3' => array(
                                'type' => 'text',
                                'label' => esc_html__('Whatsapp 3', 'swap_theme_options'),
                            ),
                             'email_1' => array(
                                'type' => 'text',
                                'label' => esc_html__('Email 1', 'swap_theme_options'),
                            ),
                            'email_2' => array(
                                'type' => 'text',
                                'label' => esc_html__('Email 2', 'swap_theme_options'),
                            ),
                            'email_3' => array(
                                'type' => 'text',
                                'label' => esc_html__('Email 3', 'swap_theme_options'),
                            ),
                             'address_1' => array(
                                'type' => 'textarea',
                                'label' => esc_html__('Address 1', 'swap_theme_options'),
                            ),
                               'address_2' => array(
                                'type' => 'textarea',
                                'label' => esc_html__('Address 2', 'swap_theme_options'),
                            ),
                               'address_3' => array(
                                'type' => 'textarea',
                                'label' => esc_html__('Address 3', 'swap_theme_options'),
                            ),
                         
                            'google_map_1' => array(
                                'type' => 'text',
                                'label' => esc_html__('Google Map 1', 'swap_theme_options'),
                            ),
                             'google_map_2' => array(
                                'type' => 'text',
                                'label' => esc_html__('Google Map 2', 'swap_theme_options'),
                            ),
                             'google_map_3' => array(
                                'type' => 'text',
                                'label' => esc_html__('Google Map 3', 'swap_theme_options'),
                            ),
                                 'opening_hour' => array(
                                'type' => 'textarea',
                                'label' => esc_html__('Opening Hour', 'swap_theme_options'),
                            ),
                            'promo_popup' => array(
                                'type' => 'checkbox',
                                'label' => esc_html__('Show Promo Popup', 'swap_theme_options'),
                            ),
                            'promo_popup_title' => array(
                                'type' => 'text',
                                'label' => esc_html__('Promo Popup Title', 'swap_theme_options'),
                                'dependency' => array(
                                    'key' => 'promo_popup',
                                    'value' => 'not_empty'
                                )
                            ),
                            'promo_popup_image' => array(
                                'type' => 'image',
                                'label' => esc_html__('Promo Popup Image', 'swap_theme_options'),
                                'dependency' => array(
                                    'key' => 'promo_popup',
                                    'value' => 'not_empty'
                                )
                            ),
                            'enable_preloader' => array(
                                'type' => 'checkbox',
                                'label' => esc_html__('Enable Preloader', 'swap_theme_options'),
                            ),
                        )
                    ),
                    'section_1_0' => array(
                        'name' => esc_html__('Header', 'swap_theme_options'),
                        'fields' => array(
                            'logo' => array(
                                'type' => 'image',
                                'label' => esc_html__('Site logo', 'swap_theme_options'),
                            ),
                             'fav_icon' => array(
                                'type' => 'image',
                                'label' => esc_html__('Fav Icon', 'swap_theme_options'),
                            ),
                             'sticky_header' => array(
                                'type' => 'checkbox',
                                'label' => esc_html__('Sticky Header', 'swap_theme_options'),
                            ),
                            'header_script' => array(
                                'type' => 'textarea',
                                'label' => esc_html__('Header Script', 'swap_theme_options'),
                            ),
                          
                       
                        )
                    ),
                    'section_1_1' => array(
                        'name' => esc_html__('Page', 'swap_theme_options'),
                        'fields' => array(
                              'page_head_bg_img' => array(
                                'type' => 'image',
                                'label' => esc_html__('Page Header Img BG', 'swap_theme_options'),
                            ),
                            'show_title' => array(
                                'type' => 'checkbox',
                                'label' => esc_html__('Show Page Title', 'swap_theme_options'),
                            ),
                            'show_sidebar' => array(
                                'type' => 'checkbox',
                                'label' => esc_html__('Show Page Sidebar', 'swap_theme_options'),
                            ),
                        )
                    ),
                    'section_1_2' => array(
                        'name' => esc_html__('Style', 'swap_theme_options'),
                        'fields' => array(
                            'primary_color' => array(
                                'type' => 'color',
                                'label' => esc_html__('Primary Color', 'swap_theme_options'),
                                'columns' => '50'
                            ),
                            'secondary_color' => array(
                                'type' => 'color',
                                'label' => esc_html__('Secondary Color', 'swap_theme_options'),
                                'columns' => '50'
                            ),
                            'third_color' => array(
                                'type' => 'color',
                                'label' => esc_html__('Third Color', 'swap_theme_options'),
                                'columns' => '50'
                            ),
                            'page_color' => array(
                                'type' => 'color',
                                'label' => esc_html__('Site Background Color', 'swap_theme_options'),
                                'columns' => '50'
                            ),
                            'body' => array(
                                'type' => 'typography',
                                'label' => esc_html__('Body Font', 'swap_theme_options'),
                                'selector' => 'body, .normal-font'
                            ),
                            'default_header_font_family' => array(
                                'type' => 'select',
                                'label' => esc_html__('Default Headings Font Family', 'swap_theme_options'),
                                'options' => swap_get_google_fonts()
                            ),
                            'default_header_font_color' => array(
                                'type' => 'color',
                                'label' => esc_html__('Default Headings Font Color', 'swap_theme_options'),
                            ),
                            'h1, .h1' => array(
                                'type' => 'typography',
                                'label' => esc_html__('H1', 'swap_theme_options'),
                            ),
                            'h2, .h2' => array(
                                'type' => 'typography',
                                'label' => esc_html__('H2', 'swap_theme_options'),
                            ),
                            'h3, .h3' => array(
                                'type' => 'typography',
                                'label' => esc_html__('H3', 'swap_theme_options'),
                            ),
                            'h4, .h4' => array(
                                'type' => 'typography',
                                'label' => esc_html__('H4', 'swap_theme_options'),
                            ),
                            'h5, .h5' => array(
                                'type' => 'typography',
                                'label' => esc_html__('H5', 'swap_theme_options'),
                            ),
                            'h6, .h6' => array(
                                'type' => 'typography',
                                'label' => esc_html__('H6', 'swap_theme_options'),
                            ),
                        )
                    ),
                    'section_3' => array(
                        'name' => esc_html__('Footer', 'swap_theme_options'),
                        'fields' => array(
                             'footer_logo' => array(
                                'type' => 'image',
                                'label' => esc_html__('Footer logo', 'swap_theme_options'),
                            ),
                            'footer_main_bg' => array(
                                'type' => 'color',
                                'label' => esc_html__('Footer Background Color', 'swap_theme_options'),
                                'columns' => '50'
                            ),
                            'footer_main_text_color' => array(
                                'type' => 'color',
                                'label' => esc_html__('Footer Text Color', 'swap_theme_options'),
                                'columns' => '50'
                            ),
                            'footer_main_links_color' => array(
                                'type' => 'color',
                                'label' => esc_html__('Footer Links Color', 'swap_theme_options'),
                                'columns' => '50'
                            ),
                            'footer_main_links_action_color' => array(
                                'type' => 'color',
                                'label' => esc_html__('Footer Links Action Color', 'swap_theme_options'),
                                'columns' => '50'
                            ),
                         
                        
                            'copyright' => array(
                                'type' => 'text',
                                'label' => esc_html__('Copyright', 'swap_theme_options'),
                            ),
                            'copyright_image' => array(
                                'type' => 'image',
                                'label' => esc_html__('Copyright image', 'swap_theme_options'),
                            ),
                               'footer_script' => array(
                                'type' => 'textarea',
                                'label' => esc_html__('Footer Script', 'swap_theme_options'),
                            ),
                        )
                    ),
                    'section_4' => array(
                        'name' => esc_html__('Socials', 'swap_theme_options'),
                        'fields' => array(
                            'socials' => array(
                                'type' => 'socials',
                                'label' => 'Social Links'
                            )
                        )
                    ),
                 
                    'section_5' => array(
                        'name' => esc_html__('Archive Pages', 'swap_theme_options'),
                        'fields' => array(
                            '404_content_bg_img' => array(
                                'type' => 'image',
                                'label' => esc_html__('404 Page Content Img BG', 'swap_theme_options'),
                            ),
                          
                            
                            'categ_head_bg_img' => array(
                                'type' => 'image',
                                'label' => esc_html__('Category Page Header Img BG', 'swap_theme_options'),
                            ),
                            'tag_head_bg_img' => array(
                                'type' => 'image',
                                'label' => esc_html__('Tags Page Header Img BG', 'swap_theme_options')
                            ),
                            'search_head_bg_img' => array(
                                'type' => 'image',
                                'label' => esc_html__('Search Page Header Img BG', 'swap_theme_options'),
                            ),
                        )
                    ),
                 
                )
            )
        ));
    }

    function swap_to_get_settings()
    {
        self::$themeOptions = get_option('swap_to_settings', array());
        return self::$themeOptions;
    }

    private static function set_typography_fonts()
    {
        $to = self::$themeOptions;

        if (isset($to['default_header_font_family']) && !empty($to['default_header_font_family'])) self::$typography_fonts[] = $to['default_header_font_family'];

        foreach ($to as $k => $val) {
            $setting = json_decode($val);
            if (!is_null($setting) && is_object($setting)) {
                foreach ($setting as $key => $value) {
                    $key = str_replace('"', '', $key);
                    if ($key == 'font-family') self::$typography_fonts[] = $value;
                }
            }
        }
    }

    function swap_to_settings_page_view()
    {
        $metabox = $this->swap_to_settings();
        $settings = $this->swap_to_get_settings();

        foreach ($metabox['args']['swap_to_settings'] as $section_name => $section) {
            foreach ($section['fields'] as $field_name => $field) {
                $default_value = (!empty($field['value'])) ? $field['value'] : '';
                $metabox['args']['swap_to_settings'][$section_name]['fields'][$field_name]['value'] = (!empty($settings[$field_name])) ? $settings[$field_name] : $default_value;
            }
        }
        require_once(SWAP_TO_DIR . '/settings/view/main.php');
    }

    function swap_save_settings()
    {
        if (empty($_REQUEST['name'])) die;
        $id = sanitize_text_field($_REQUEST['name']);
        $settings = array();
        $request_body = file_get_contents('php://input');
        if (!empty($request_body)) {
            $request_body = json_decode($request_body, true);
            foreach ($request_body as $section_name => $section) {
                foreach ($section['fields'] as $field_name => $field) {
                    $settings[$field_name] = $field['value'];
                }
            }
        }

        $update = update_option($id, $settings);
        self::swap_to_get_settings();

        do_action('swap_set_custom_color');

        wp_send_json($update);
    }

    function get_settings()
    {
        $option = sanitize_text_field($_GET['option_name']);
        wp_send_json(get_option($option, array()));
    }

}

new SWAP_TO_Settings;
