<?php

require_once SWAP_TO_DIR . '/post_type/taxonomy_meta/fields/default.php';
require_once SWAP_TO_DIR . '/post_type/taxonomy_meta/fields/select.php';
require_once SWAP_TO_DIR . '/post_type/taxonomy_meta/fields/image.php';
require_once SWAP_TO_DIR . '/post_type/taxonomy_meta/fields/icon.php';

function swap_to_term_meta_fields()
{

    $posts = swap_to_get_posts('swap-banners');

	return apply_filters('swap_to_term_meta_fields', array(
		'product_category' => array(
		
            'x_category_title_image' => array(
                'label' => esc_html__('Category Title Image', 'swap_theme_options'),
                'type'  => 'image',
            ),
         
		),
			'product_brand' => array(
		
            'x_brand_title_image' => array(
                'label' => esc_html__('Brand Title Image', 'swap_theme_options'),
                'type'  => 'image',
            ),
         
		)
	));
}

add_action('init', 'swap_to_register_term_meta');
function swap_to_register_term_meta()
{
	$term_meta = swap_to_term_meta_fields();
	foreach ($term_meta as $taxonomy => $meta_fields) {
		foreach ($meta_fields as $meta_field_key => $meta_field) {
			register_meta('term', $meta_field_key, 'swap_to_sanitize_term_meta');
		}
	}

    $taxonomies = swap_to_term_meta_fields();
    foreach ($taxonomies as $taxonomy => $fields) {
        add_action("{$taxonomy}_add_form_fields", 'swap_to_add_term_meta_fields');
        add_action("{$taxonomy}_edit_form_fields", 'swap_to_edit_term_meta_fields');

        add_action("edit_{$taxonomy}", 'swap_to_save_term_meta_field');
        add_action("create_{$taxonomy}", 'swap_to_save_term_meta_field');
    }

}

function swap_to_sanitize_term_meta($value)
{
	return sanitize_text_field($value);
}

function swap_to_get_term_meta_text($term_id, $term_key)
{
	$value = get_term_meta($term_id, $term_key, true);
	$value = swap_to_sanitize_term_meta($value);
	return $value;
}

function swap_to_add_term_meta_fields($tax)
{
	$meta = swap_to_term_meta_fields();
	$fields = $meta[$tax]; ?>
 
		<?php foreach ($fields as $field_key => $field): ?>

            <tr class="form-field">
                <th scope="row">
                    <label for="<?php echo esc_attr($field_key) ?>"><?php echo sanitize_text_field($field['label']); ?></label>
                </th>
                <td>
					<?php switch ($field['type']) {
						case 'image':
							swap_to_term_meta_field_image($field_key, '');
							break;
                        case 'icon':
                            swap_to_term_meta_field_icon($field_key, '');
                            break;
                        case 'select':
                            swap_to_term_meta_field_select($field_key, '', $field);
                            break;
						default:
							swap_to_term_meta_field_default($field_key, '');
					} ?>
                </td>
            </tr>


		<?php endforeach; ?>
    
<?php }

function swap_to_edit_term_meta_fields($term)
{
	$taxonomy = $term->taxonomy;
	$meta = swap_to_term_meta_fields();
	$fields = $meta[$taxonomy]; ?>

		<?php foreach ($fields as $field_key => $field):
			$value = swap_to_get_term_meta_text($term->term_id, $field_key);
			?>

            <tr class="form-field">
                <th scope="row">
                    <label for="<?php echo esc_attr($field_key) ?>"><?php echo sanitize_text_field($field['label']); ?></label>
                </th>
                <td>
					<?php switch ($field['type']) {
						case 'image':
                            swap_to_term_meta_field_image($field_key, $value);
                            break;
                        case 'icon':
                            swap_to_term_meta_field_icon($field_key, $value);
                            break;
                        case 'select':
                            swap_to_term_meta_field_select($field_key, $value, $field);
                            break;
						default:
							swap_to_term_meta_field_default($field_key, $value);
					} ?>
                </td>
            </tr>


		<?php endforeach; ?>
    
<?php }

function swap_to_save_term_meta_field($term_id)
{
	if (!empty($_POST['taxonomy'])) {
		$taxonomy = sanitize_text_field($_POST['taxonomy']);
		$meta = swap_to_term_meta_fields();
		if (!empty($meta[$taxonomy])) {
			$fields = $meta[$taxonomy];
			foreach ($fields as $field_key => $field) {
				$field_value = (!empty($_POST[$field_key])) ? sanitize_text_field($_POST[$field_key]) : '';
				update_term_meta($term_id, $field_key, $field_value);
			}
		}
	}
}