<?php

if (!defined('ABSPATH')) exit; //Exit if accessed directly

class SWAP_TO_Taxonomies
{
    function __construct()
    {
        add_action('init', array($this, 'taxonomies_init'), -1);
    }

    function taxonomies()
    {
        return apply_filters('swap_to_taxonomies', array(
               'product_category' => array(
                'post_type' => 'product',
                'args' => array(
                    'hierarchical' => true,
                    'labels' => array(
                        'name' => _x('Category', 'taxonomy general name', 'swap_theme_options'),
                        'singular_name' => _x('Category', 'taxonomy singular name', 'swap_theme_options'),
                        'search_items' => __('Search Category', 'swap_theme_options'),
                        'all_items' => __('All Category', 'swap_theme_options'),
                        'parent_item' => __('Parent Category', 'swap_theme_options'),
                        'parent_item_colon' => __('Parent Category:', 'swap_theme_options'),
                        'edit_item' => __('Edit Category', 'swap_theme_options'),
                        'update_item' => __('Update Category', 'swap_theme_options'),
                        'add_new_item' => __('Add New Category', 'swap_theme_options'),
                        'new_item_name' => __('New Category Name', 'swap_theme_options'),
                        'menu_name' => __('Category', 'swap_theme_options'),
                    ),
                    		'public'            => true,
                    'show_ui' => true,
                    'show_admin_column' => true,
                    'query_var' => true,
                    	'show_in_nav_menus' => true,
		
			'show_tagcloud'     => true,
		
                    'rewrite' => array(
                        'slug' => 'brands'
                    )
                )
            ),
           'brand_taxonomy' => array(
                'post_type' => 'product',
                'args' => array(
                    'hierarchical' => true,
                    'labels' => array(
                        'name' => _x('Brand', 'taxonomy general name', 'swap_theme_options'),
                        'singular_name' => _x('Brand', 'taxonomy singular name', 'swap_theme_options'),
                        'search_items' => __('Search Brands', 'swap_theme_options'),
                        'all_items' => __('All Brands', 'swap_theme_options'),
                        'parent_item' => __('Parent Brand', 'swap_theme_options'),
                        'parent_item_colon' => __('Parent Brand:', 'swap_theme_options'),
                        'edit_item' => __('Edit Brand', 'swap_theme_options'),
                        'update_item' => __('Update Brand', 'swap_theme_options'),
                        'add_new_item' => __('Add New Brand', 'swap_theme_options'),
                        'new_item_name' => __('New Brand Name', 'swap_theme_options'),
                        'menu_name' => __('Brand', 'swap_theme_options'),
                    ),
                    	'public'            => true,
                    'show_ui' => true,
                    'show_admin_column' => true,
                    'query_var' => true,
                    	'show_in_nav_menus' => true,
		
			'show_tagcloud'     => true,
                    'rewrite' => array(
                        'slug' => 'brands'
                    )
                )
            ),
            
            'product_tag' => array(
                'post_type' => 'product',
                'args' => array(
                    'hierarchical' => false,
                    'labels' => array(
                        'name' => _x('Tags', 'taxonomy general name', 'swap_theme_options'),
                        'singular_name' => _x('Tag', 'taxonomy singular name', 'swap_theme_options'),
                        'search_items' => __('Search Tags', 'swap_theme_options'),
                        'all_items' => __('All Tags', 'swap_theme_options'),
                        'parent_item' => __('Parent Tag', 'swap_theme_options'),
                        'parent_item_colon' => __('Parent Tag:', 'swap_theme_options'),
                        'edit_item' => __('Edit Tag', 'swap_theme_options'),
                        'update_item' => __('Update Tag', 'swap_theme_options'),
                        'add_new_item' => __('Add New Tag', 'swap_theme_options'),
                        'new_item_name' => __('New Tag', 'swap_theme_options'),
                        'menu_name' => __('Tags', 'swap_theme_options'),
                    ),
                    		'public'            => true,
                    'show_ui' => true,
                    'show_admin_column' => true,
                    'query_var' => true,
                    	'show_in_nav_menus' => true,
		
			'show_tagcloud'     => true,
		
                    'rewrite' => array(
                        'slug' => 'brands'
                    )
                )
            ),
            
           'blog_category' => array(
                'post_type' => 'blog',
                'args' => array(
                    'hierarchical' => true,
                    'labels' => array(
                        'name' => _x('Category', 'taxonomy general name', 'swap_theme_options'),
                        'singular_name' => _x('Category', 'taxonomy singular name', 'swap_theme_options'),
                        'search_items' => __('Search Category', 'swap_theme_options'),
                        'all_items' => __('All Category', 'swap_theme_options'),
                        'parent_item' => __('Parent Category', 'swap_theme_options'),
                        'parent_item_colon' => __('Parent Category:', 'swap_theme_options'),
                        'edit_item' => __('Edit Category', 'swap_theme_options'),
                        'update_item' => __('Update Category', 'swap_theme_options'),
                        'add_new_item' => __('Add New Category', 'swap_theme_options'),
                        'new_item_name' => __('New Category Name', 'swap_theme_options'),
                        'menu_name' => __('Category', 'swap_theme_options'),
                    ),
                    		'public'            => true,
                    'show_ui' => true,
                    'show_admin_column' => true,
                    'query_var' => true,
                    	'show_in_nav_menus' => true,
		
			'show_tagcloud'     => true,
		
                    'rewrite' => array(
                        'slug' => 'blogs'
                    )
                )
            ),
        ));
    }

    function taxonomies_init()
    {
        $taxonomies = $this->taxonomies();
        foreach ($taxonomies as $taxonomy => $taxonomy_args) {
            register_taxonomy($taxonomy, $taxonomy_args['post_type'], $taxonomy_args['args']);
        }
    }
}

new SWAP_TO_Taxonomies();