<?php
 /**
 * Template Name: Product Grid Page
 *
 * @package WordPress
*/

get_header(); 




?>

<?php
if (is_category() || is_tag() || is_tax()) {

    $term = $wp_query->get_queried_object();

    if ((is_taxonomy_hierarchical($term->taxonomy) && $term->parent) && $parents = breadcrumb_get_term_parents($term->parent, $term->taxonomy))
        $item = array_merge($item, $parents);

    $cat = get_terms('product_category');

    foreach ($cat as $catVal) {
        // Get the category title
        $category_title = $catVal->name;

        if (function_exists('z_taxonomy_image_url')) {
            $image_url = z_taxonomy_image_url($catVal->term_id);
        }

        $category_link = get_category_link($catVal->term_id);

        if ($category_title == $term->name) {
?>
<?php

$category_image_url = get_term_meta($catVal->term_id, 'x_category_title_image', true);
  $category_image_url = swap_get_image_url($category_image_url);

if (empty($category_image_url)) $category_image_url = TMPL . 'assets/assets/images/breadcrumb.webp';


?>
<div class="section dark my-0" style="background: linear-gradient(rgba(21, 57, 38, 0.1), rgb(86 86 88 / 47%)), url('<?php echo esc_url($category_image_url); ?>') no-repeat center 85% / cover; padding: 110px 0 110px 0;">
    
    

                

                <div class="container">
                    <div class="text-center mb-6">
                        <h3 class="fs-big text-uppercase fw-800"><?php echo $term->name; ?></h3>
                    </div>
                    <div class="row text-center">
                        <div>
                            <a href="https://store.aerosmart.ae/" class="ms-3 ms-lg-5 btn-breadcrumb mt-2 btn text-dark bg-white rounded-3 px-2 py-2 text-transform-none ls-0 shadow-sm"><i class="fa-solid fa-bag-shopping me-2"></i>Visit Our Store</a>
                            <a href="https://www.aerosmart.ae/contact-us" class="ms-3 ms-lg-5 btn-breadcrumb mt-2 btn text-dark bg-white rounded-3 px-2 py-2 text-transform-none ls-0 shadow-sm"><i class="fa-solid fa-envelope me-2"></i>Get In Touch</a>
                        </div>
                    </div>
                </div>
            </div>
<?php
        }
    }
}
?>





<div class="container">
<div class=" m-0 p-0 pt-6 pb-5">
 <?php if (is_category() || is_tag() || is_tax()) {

        $term = $wp_query->get_queried_object();
        //$taxonomy = get_taxonomy( $term->taxonomy );

        if ((is_taxonomy_hierarchical($term->taxonomy) && $term->parent) && $parents = breadcrumb_get_term_parents($term->parent, $term->taxonomy))
          $item = array_merge($item, $parents);
 $cat = get_terms('product_category');

		foreach ($cat as $catVal) {
        // Get the category title
        $category_title = $catVal->name;
			   if ($category_title == $term->name) {
        
?>
       
<h2 class="text-title-light text-center mb-6" ><?php echo $catVal->description; ?></h2>


<?php } 
		}
}
	?>
<div class="row ">



<?php
global $query_string; 
query_posts($query_string . '&caller_get_posts=1&order=ASC');

$key = 0;

if (have_posts()) : while (have_posts()) : the_post();
	
	
	$image_thumb = '';
								
	if(has_post_thumbnail(get_the_ID(), 'swap-product_grid'))
	{
	    $image_id = get_post_thumbnail_id(get_the_ID());
	    $image_thumb = wp_get_attachment_image_src($image_id, 'swap-product_grid', true);
	}
	$drone_ID = get_the_ID();
	 $drone_image = get_post_meta($drone_ID, 'product_image', true);
	     $drone_image = swap_get_image_url($drone_image);
	    
if (empty($drone_image)) $drone_image = TMPL . 'assets/assets/images/logo.svg';
?>






<div class="col-lg-4 col-sm-6 mb-5">
<a href="<?php echo get_permalink( ); ?>"><div class="feature-box hover-effect h-p  fbox-center fbox-bg fbox-light fbox-lg ">
<div class="fbox-icon p-icon">
<i ><img src="<?php echo esc_url($drone_image); ?>" class="border-0 bg-transparent " data-animate="fadeInRight"  style="z-index: 2;" alt="Image"></i>
</div>
<div class="fbox-content">
<h3 class="mb-4 text-transform-none ls-0"><a href="<?php echo get_permalink( ); ?>" class="text-dark"><?php echo get_the_title(); ?></a></h3>
<p class="mb-4"><?php
                                $excerpt = get_the_excerpt();
                                echo string_limit_words($excerpt, 15) . '...';?>

</div>
<a href="<?php echo get_permalink( ); ?>" class="btn btn-success " type="submit" data-animate="fadeInLeft">View Details</a>

</div></a>
</div>







<?php $key++;  endwhile; endif; ?>
<?php
		
			    if($wp_query->max_num_pages > 1)
			    { ?>
 <!-- start pagination -->
                        
                            
			    <?php	if (function_exists("swap_pagination")) 
			    	{
			    	swap_pagination($wp_query->max_num_pages);
			    	}
			    	else
			    	{
			     posts_nav_link(' '); 
			    	}
			    ?>
			   
			    
			    
                        <!-- end pagination -->
			     
			     <?php
			     }
			?>
</div>




</div>
</div>


<div class="mt-0 parallax mb-0 pb-5 pad-contact" style="background: linear-gradient(to right, #ffffff , #ffffff66),url('https://www.aerosmart.ae/wp-content/uploads/2023/11/contact-scaled.webp') no-repeat center center; background-size: cover; ">
<div class="container">
	<div class="row shadow bg-light border-dotted-line" style="background-image:url('https://www.aerosmart.ae/wp-content/uploads/2023/11/background_form.webp')">
<div class="col-lg-4 dark">
	<?php  
    $cat = get_terms('product_category');
    foreach ($cat as $catVal) {
        // Get the category title
        $category_title = $catVal->name;
	}
	$current_category_id = get_queried_object_id();
        if (function_exists('z_taxonomy_image_url')) {
            $image_url = z_taxonomy_image_url($current_category_id);

            // Check if the image URL is set
            if ($image_url) {
                ?>
                <img src="<?php echo $image_url; ?>" />
                <?php 
            }
        }
    
?>

	<img class="form-dji-logo" src="https://www.aerosmart.ae/wp-content/uploads/2023/11/dji_logo.png" />
<h4 class="text-center mb-2 mt-2 gray-color">Request for a Quote</h4>
	<?php $current_category_name = single_cat_title('', false);
	?>
	<p class="offset-lg-1 fillup-text">
		Your journey into the extraordinary begins here. Share your details for a personalized <?php echo $current_category_name; ?>  quote and let your imagination soar. 
	</p>

</div>
<div class="col-lg-8 p-5">
<?php	//echo $current_category_name; 
	 if($current_category_name == 'Enterprise') { 
		 echo do_shortcode('[contact-form-7 id="259de29" title="Enquiry" html_id="template-contactform" html_class="row mb-0"]'); 
	 } else {
	 echo do_shortcode('[contact-form-7 id="132a828" title="Enquiry" html_id="template-contactform" html_class="row mb-0"]'); 
	 }
	?>
</div>
</div>
	
	

</div>
</div>





<?php get_footer(); ?>