<?php


/* start post type */
if ( ! class_exists( 'Services_Post_Type' ) ) :

class Services_Post_Type {

    private $theme = 'swap';
	public function __construct() {
      
  
		// Add the services post type and taxonomies
		add_action( 'init', array( $this, 'services_init' ) );

		// Thumbnail support for services posts
		add_theme_support( 'post-thumbnails', array( 'services' ) );

		// Add thumbnails to column view
		add_filter( 'manage_edit-services_columns', array( $this, 'add_thumbnail_column_services'), 10, 1 );
		add_action( 'manage_pages_custom_column', array( $this, 'display_thumbnail_services' ), 10, 1 );

		// Allow filtering of posts by taxonomy in the admin view
		add_action( 'restrict_manage_posts', array( $this, 'add_taxonomy_filters' ) );

		// Show services post counts in the dashboard
		add_action( 'right_now_content_table_end', array( $this, 'add_services_counts' ) );
		
        // Add custom metaboxes
        //add_action( 'cmb2_init', array( $this, 'add_services_metaboxes' ) );
        
		//Add taxonomy terms as body classes
		//add_filter( 'body_class', array( $this, 'add_body_classes' ) );
        //add_action( 'add_meta_boxes', array( $this, 'add_events_metaboxes' ) );
        //add_action( 'save_post', array( $this, 'swap_services_meta_details_save'), 1, 2); // save the custom fields
	}
    
	/**
	 * Load the plugin text domain for translation.
	 */




	/**
	 * Initiate registrations of post type and taxonomies.
	 *
	 * @uses services Item_Post_Type::register_post_type()
	 * @uses services Item_Post_Type::register_taxonomy_tag()
	 * @uses services Item_Post_Type::register_taxonomy_category()
	 */
	public function services_init() {
	
		$this->register_post_type();
		$this->register_taxonomy_category();
		$this->register_taxonomy_tag();
        //$this->add_events_metaboxes();
        flush_rewrite_rules();
	}

	/**
	 * Get an array of all taxonomies this plugin handles.
	 *
	 * @return array Taxonomy slugs.
	 */
	protected function get_taxonomies() {
		return array( 'services_category', 'services_tag' );
	}



	/**
	 * Enable the services Item custom post type.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/register_post_type
	 */
	protected function register_post_type() {
		$labels = array(
			'name'               => __( 'Services', 'swap' ),
			'singular_name'      => __( 'Services Images', 'swap' ),
			'add_new'            => __( 'Add New', 'swap' ),
			'add_new_item'       => __( 'Add New', 'swap' ),
			'edit_item'          => __( 'Edit Item', 'swap' ),
			'new_item'           => __( 'Add New  Item', 'swap' ),
			'view_item'          => __( 'View Item', 'swap' ),
			'search_items'       => __( 'Search Items', 'swap' ),
			'not_found'          => __( 'No items found', 'swap' ),
			'not_found_in_trash' => __( 'No items found in trash', 'swap' ),
		);
		
		$args = array(
			'menu_icon' => 'dashicons-admin-tools
',
			'labels'          => $labels,
			'public'          => true,
			'show_in_rest' => true,
			'supports'        => array(
				'title',
				'editor',
				'excerpt',
				'thumbnail',
				'comments',
				'author',
				'custom-fields',
				'revisions',
			),
			'capability_type' => 'page',
			'menu_position'   => 5,
			'hierarchical'      => true,
			'has_archive'     => true,
				'show_in_rest' => true,
		);

		$args = apply_filters( 'swap_args', $args );
		register_post_type( 'services', $args );
	}



	/**
	 * Register a taxonomy for services Item Tags.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/register_taxonomy
	 */
	protected function register_taxonomy_tag() {
		$labels = array(
			'name'                       => __( 'Tags', 'swap' ),
			'singular_name'              => __( 'Tag', 'swap' ),
			'menu_name'                  => __( 'Tags', 'swap' ),
			'edit_item'                  => __( 'Edit Tag', 'swap' ),
			'update_item'                => __( 'Update Tag', 'swap' ),
			'add_new_item'               => __( 'Add New Tag', 'swap' ),
			'new_item_name'              => __( 'New  Tag Name', 'swap' ),
			'parent_item'                => __( 'Parent Tag', 'swap' ),
			'parent_item_colon'          => __( 'Parent Tag:', 'swap' ),
			'all_items'                  => __( 'All Tags', 'swap' ),
			'search_items'               => __( 'Search  Tags', 'swap' ),
			'popular_items'              => __( 'Popular Tags', 'swap' ),
			'separate_items_with_commas' => __( 'Separate tags with commas', 'swap' ),
			'add_or_remove_items'        => __( 'Add or remove tags', 'swap' ),
			'choose_from_most_used'      => __( 'Choose from the most used tags', 'swap' ),
			'not_found'                  => __( 'No  tags found.', 'swap' ),
		);

		$args = array(
			'labels'            => $labels,
			'public'            => true,
			'show_in_nav_menus' => true,
			'show_ui'           => true,
			'show_tagcloud'     => true,
			'hierarchical'      => false,
			'show_admin_column' => true,
			'query_var'         => true,
				'show_in_rest' => true,

		);

		$args = apply_filters( 'swap_tag_args', $args );

		register_taxonomy( 'services_tag', array( 'services' ), $args );

	}

	/**
	 * Register a taxonomy for services Item Categories.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/register_taxonomy
	 */
	protected function register_taxonomy_category() {
		

		$labels = array(
			'name'                       => __( 'Categories', 'swap' ),
			'singular_name'              => __( 'Category', 'swap' ),
			'menu_name'                  => __( 'Categories', 'swap' ),
			'edit_item'                  => __( 'Edit Category', 'swap' ),
			'update_item'                => __( 'Update Category', 'swap' ),
			'add_new_item'               => __( 'Add New Category', 'swap' ),
			'new_item_name'              => __( 'New Category Name', 'swap' ),
			'parent_item'                => __( 'Parent Category', 'swap' ),
			'parent_item_colon'          => __( 'Parent Category:', 'swap' ),
			'all_items'                  => __( 'All Categories', 'swap' ),
			'search_items'               => __( 'Search Categories', 'swap' ),
			'popular_items'              => __( 'Popular Categories', 'swap' ),
			'separate_items_with_commas' => __( 'Separate categories with commas', 'swap' ),
			'add_or_remove_items'        => __( 'Add or remove categories', 'swap' ),
			'choose_from_most_used'      => __( 'Choose from the most used categories', 'swap' ),
			'not_found'                  => __( 'No categories found.', 'swap' ),
		);

		$args = array(
			'labels'            => $labels,
			'public'            => true,
			'show_in_nav_menus' => true,
			'show_ui'           => true,
			'show_tagcloud'     => true,
			'hierarchical'      => true,
			'show_admin_column' => true,
			'query_var'         => true,
				'show_in_rest' => true,
		);

		$args = apply_filters( 'swap_category_args', $args );

        register_taxonomy( 'services_category', array( 'services' ), $args );
	}

		

	/**
	 * Add taxonomy terms as body classes.
	 *
	 * If the taxonomy doesn't exist (has been unregistered), then get_the_terms() returns WP_Error, which is checked
	 * for before adding classes.
	 *
	 * @param array $classes Existing body classes.
	 *
	 * @return array Amended body classes.
	 */
	public function add_body_classes( $classes ) {
		$taxonomies = $this->get_taxonomies();

		foreach( $taxonomies as $taxonomy ) {
			$terms = get_the_terms( get_the_ID(), $taxonomy );
			if ( $terms && ! is_wp_error( $terms ) ) {
				foreach( $terms as $term ) {
					$classes[] = sanitize_html_class( str_replace( '_', '-', $taxonomy ) . '-' . $term->slug );
				}
			}
		}

		return $classes;
	}

	/**
	 * Add columns to services Item list screen.
	 *
	 * @link http://wptheming.com/2010/07/column-edit-pages/
	 *
	 * @param array $columns Existing columns.
	 *
	 * @return array Amended columns.
	 */
	public function add_thumbnail_column_services( $columns ) {
		$column_thumbnail = array( 'thumbnail' => __( 'Thumbnail', 'swap' ) );
		return array_slice( $columns, 0, 2, true ) + $column_thumbnail + array_slice( $columns, 1, null, true );
	}

	/**
	 * Custom column callback
	 *
	 * @global stdClass $post Post object.
	 *
	 * @param string $column Column ID.
	 */
	public function display_thumbnail_services( $column ) {
		global $post;
        if( $post->post_type == 'services' ){
            switch ( $column ) {
                case 'thumbnail':
                    echo get_the_post_thumbnail( $post->ID, array(35, 35, true ), array('class' => 'img-responsive') );
                break;
            }
        }
	}

	/**
	 * Add taxonomy filters to the services admin page.
	 *
	 * Code artfully lifted from http://pippinsplugins.com/
	 *
	 * @global string $typenow
	 */
	public function add_taxonomy_filters() {
		global $typenow;

		// An array of all the taxonomies you want to display. Use the taxonomy name or slug
		$taxonomies = $this->get_taxonomies();

		// Must set this to the post type you want the filter(s) displayed on
		if ( 'services' != $typenow ) {
			return;
		}

		foreach ( $taxonomies as $tax_slug ) {
			$current_tax_slug = isset( $_GET[$tax_slug] ) ? $_GET[$tax_slug] : false;
			$tax_obj          = get_taxonomy( $tax_slug );
			$tax_name         = $tax_obj->labels->name;
			$terms            = get_terms( $tax_slug );
			if ( 0 == count( $terms ) ) {
				return;
			}
			echo '<select name="' . esc_attr( $tax_slug ) . '" id="' . esc_attr( $tax_slug ) . '" class="postform">';
			echo '<option>' . esc_html( $tax_name ) .'</option>';
			foreach ( $terms as $term ) {
				printf(
					'<option value="%s"%s />%s</option>',
					esc_attr( $term->slug ),
					selected( $current_tax_slug, $term->slug ),
					esc_html( $term->name . '(' . $term->count . ')' )
				);
			}
			echo '</select>';
		}
	}

	/**
	 * Add services Item count to "Right Now" dashboard widget.
	 *
	 * @return null Return early if services post type does not exist.
	 */
	public function add_services_counts() {
		if ( ! post_type_exists( 'services' ) ) {
			return;
		}

		$num_posts = wp_count_posts( 'services' );

		// Published items
		$href = 'edit.php?post_type=services';
		$num  = number_format_i18n( $num_posts->publish );
		$num  = $this->link_if_can_edit_posts( $num, $href );
		$text = _n( 'services Item Item', 'services Item Items', intval( $num_posts->publish ) );
		$text = $this->link_if_can_edit_posts( $text, $href );
		$this->display_dashboard_count( $num, $text );

		if ( 0 == $num_posts->pending ) {
			return;
		}

		// Pending items
		$href = 'edit.php?post_status=pending&amp;post_type=services';
		$num  = number_format_i18n( $num_posts->pending );
		$num  = $this->link_if_can_edit_posts( $num, $href );
		$text = _n( 'services Item Item Pending', 'services Item Items Pending', intval( $num_posts->pending ) );
		$text = $this->link_if_can_edit_posts( $text, $href );
		$this->display_dashboard_count( $num, $text );
	}

	/**
	 * Wrap a dashboard number or text value in a link, if the current user can edit posts.
	 *
	 * @param  string $value Value to potentially wrap in a link.
	 * @param  string $href  Link target.
	 *
	 * @return string        Value wrapped in a link if current user can edit posts, or original value otherwise.
	 */
	protected function link_if_can_edit_posts( $value, $href ) {
		if ( current_user_can( 'edit_posts' ) ) {
			return '<a href="' . esc_url( $href ) . '">' . $value . '</a>';
		}
		return $value;
	}

	/**
	 * Display a number and text with table row and cell markup for the dashboard counters.
	 *
	 * @param  string $number Number to display. May be wrapped in a link.
	 * @param  string $label  Text to display. May be wrapped in a link.
	 */
	protected function display_dashboard_count( $number, $label ) {
		?>
		<tr>
			<td class="first b b-services"><?php echo esc_html( $number ); ?></td>
			<td class="t services"><?php echo esc_html( $label ); ?></td>
		</tr>
		<?php
	}
}

new Services_Post_Type;

endif;
