<?php

/*
Widget Name: Swap Slider Widget
Description: Create Slider Section
Author: Shiju

*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 


class slider_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'slider_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Slider', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Create Slider Section', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(

                'auto_play' => array(
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Turn on slider autoplay', 'swap' )
                ),
                'loop' => array(
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Loop slides', 'swap' )
                ),
                 'dots' => array(
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Dots', 'swap' )
                ),
                  'nav' => array(
                    'type' => 'checkbox',
                    'label' => esc_html__( 'Navigation', 'swap' )
                ),
                'autoplay_timeout' => array(
                    'type' => 'number',
                    'label' => esc_html__('Autoplay timeout', 'swap'),
                    'default' => ''
                ),
				
				 'image' => array(
                            'type' => 'media',
                            'label' => esc_html__( 'Choose slider image, preferably 1800 × 1070', 'swap' ),
                            'choose' => esc_html__( 'Choose image', 'swap' ),
                            'update' => esc_html__( 'Set image', 'swap' ),
                            'library' => 'image',
                            'fallback' => true
                        ),
                       
					   
					   'tagline' => array(
                            'type' => 'text',
                            'label' => esc_html__('Enter tagline', 'swap'),
                            'default' => ''
                        ),
					   
					    'title' => array(
                            'type' => 'text',
                            'label' => esc_html__('Enter title', 'swap'),
                            'default' => ''
                        ),
                         'text' => array(
                            'type' => 'textarea',
                            'label' => esc_html__('Enter text', 'swap'),
                            'default' => ''
                        ),
						
				'button_text' => array(
                   'type' => 'text',
                   'label' => esc_html__('Button Text', 'swap'),
                   'description' => esc_html__('Button CTA text', 'swap'),
                   'default' => ''
                ),
                'button_url' => array(
                   'type' => 'link',
                   'label' => esc_html__('Button Link', 'swap'),
                   'description' => esc_html__('Button url', 'swap'),
                   'default' => '#'
                ),
				
			
				
                       
						

				
				 'form_id' => array(
                    'type' => 'text',
                    'label' => esc_html__('Contact form ID', 'swap'),
                    'default' => ''
                ),
                        
            ),
            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'slider';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('slider_widget', __FILE__, 'slider_widget');

endif;