<?php
/*
Widget Name:  Services Widget
Description: Create Services Section
Author: Shiju
*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 

class services_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'services_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Services', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Create About Us Section', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(
                 'backgroundcolor' => array(
                    'type' => 'color',
                    'label' => esc_html__('About Background', 'swap'),
                    'default' => '#ffffff'
                ),
				
				'subtitle' => array(
                            'type' => 'text',
                            'label' => esc_html__('Sub Title', 'swap'),
                            'default' => ''
                        ),
						'title' => array(
                            'type' => 'text',
                            'label' => esc_html__('Title', 'swap'),
                            'default' => ''
                        ),
						'services_per_page' => array(
                            'type' => 'number',
                            'label' => esc_html__('services per page', 'swap'),
                            'default' => ''
                        ),
				               
          
				
				
				
                
                
                
       
                
             
            ),

            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'services';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('services_widget', __FILE__, 'services_widget');

endif;

