<?php

/*
Widget Name:  Faq Widget
Description: List Limited Product Offers With Countdown Timers
Author: Shiju
*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 

class faq_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'faq_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Faq', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Display Faq block with map and form', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(
                'tagline' => array(
                    'type' => 'text',
                    'label' => esc_html__('Enter tagline ', 'swap'),
                    'default' => ''
                ),
				'title' => array(
                    'type' => 'text',
                    'label' => esc_html__('Enter title', 'swap'),
                    'default' => ''
                ),
				
                'a_repeater' => array(
                    'type' => 'repeater',
                    'label' => esc_html__( 'Add FAQ Record' , 'swap' ),
                    'item_name'  => esc_html__( 'Click here to setup this record', 'swap' ),
                    'item_label' => array(
                        'selector'     => "[id*='repeat_text']",
                        'update_event' => 'change',
                        'value_method' => 'val'
                    ),
                    'fields' => array(
				
				'question' => array(
                    'type' => 'text',
                    'label' => esc_html__('Enter the question', 'swap'),
                    'default' => ''
                ),
				'answer' => array(
                    'type' => 'tinymce',
                    'label' => esc_html__('Enter the answer', 'swap'),
                    'default' => ''
                ),
				'visibility' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__( 'Temporary hide this record', 'swap' )
                        ),
                    )
                ),


                   'image1' => array(
                    'type' => 'media',
                    'label' => esc_html__( 'Choose faq section image1', 'swap' ),
                    'choose' => esc_html__( 'Choose image', 'swap' ),
                    'update' => esc_html__( 'Set image', 'swap' ),
                    'library' => 'image',
                    'fallback' => true
                ),
				'image2' => array(
                    'type' => 'media',
                    'label' => esc_html__( 'Choose faq section image2', 'swap' ),
                    'choose' => esc_html__( 'Choose image', 'swap' ),
                    'update' => esc_html__( 'Set image', 'swap' ),
                    'library' => 'image',
                    'fallback' => true
                ),	
				
                'roundedtext' => array(
                    'type' => 'text',
                    'label' => esc_html__('Enter the rounded text', 'swap'),
                    'default' => ''
                ),             
            ),

            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'faq';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('faq_widget', __FILE__, 'faq_widget');

endif;

