<?php

/*
Widget Name: Blog Single Widget
Description: Create Blog Single Section
Author: Shiju

*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 


class event_single_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'event_single_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Event Single', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Create Event Single Section', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(
					
					 'image' => array(
                    'type' => 'media',
                    'label' => esc_html__( 'Choose thumbnail image', 'swap' ),
                    'choose' => esc_html__( 'Choose image', 'swap' ),
                    'update' => esc_html__( 'Set image', 'swap' ),
                    'library' => 'image',
                    'fallback' => true
                ),
                       
						 'title' => array(
                            'type' => 'text',
                            'label' => esc_html__('Title', 'swap'),
                            'default' => ''
                        ),
					'content' => array(
                            'type' => 'tinymce',
                            'label' => esc_html__('Content', 'swap'),
                            'default' => ''
                        ),
						
                 	               
               'a_repeater' => array(
                    'type' => 'repeater',
                    'label' => esc_html__( 'Add record' , 'swap' ),
                    'item_name'  => esc_html__( 'Click here to setup this record', 'swap' ),
                    'item_label' => array(
                        'selector'     => "[id*='repeat_text']",
                        'update_event' => 'change',
                        'value_method' => 'val'
                    ),
                    'fields' => array(
           
                 'image' => array(
                    'type' => 'media',
                    'label' => esc_html__( 'Choose thumbnail image', 'swap' ),
                    'choose' => esc_html__( 'Choose image', 'swap' ),
                    'update' => esc_html__( 'Set image', 'swap' ),
                    'library' => 'image',
                    'fallback' => true
                ),
                       
					   'video' => array(
                            'type' => 'media',
                            'label' => esc_html__( 'Choose background video', 'swap' ),
                            'choose' => esc_html__( 'Choose video', 'swap' ),
                            'update' => esc_html__( 'Set video', 'swap' ),
                            'library' => 'video',
                            'fallback' => true
                        ),
					    'youtube_url' => array(
                            'type' => 'text',
                            'label' => esc_html__('YouTube Link', 'swap'),
                            'default' => ''
                        ),
						 'title' => array(
                            'type' => 'text',
                            'label' => esc_html__('Title', 'swap'),
                            'default' => ''
                        ),
						 'content' => array(
                            'type' => 'tinymce',
                            'label' => esc_html__('Content', 'swap'),
                            'default' => ''
                        ),
                        
                        'visibility' => array(
                            'type' => 'checkbox',
                            'label' => esc_html__( 'Temporary hide this record', 'swap' )
                        ),
                    )
                )
                
                 	               
        
						
						
                
                
             
            ),
            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'event_single';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('event_single_widget', __FILE__, 'event_single_widget');

endif;