<?php

/*
Widget Name: Clients Widget
Description: Create Clients Section
Author: Shiju

*/

if( class_exists( 'SiteOrigin_Widget' ) ) : 


class clients_widget extends SiteOrigin_Widget {

    function __construct() {
        //Here you can do any preparation required before calling the parent constructor, such as including additional files or initializing variables.

        //Call the parent constructor with the required arguments.
        parent::__construct(
            // The unique id for your widget.
            'clients_widget',

            // The name of the widget for display purposes.
            esc_html__('Swap Clients', 'swap'),

            // The $widget_options array, which is passed through to WP_Widget.
            // It has a couple of extras like the optional help URL, which should link to your sites help or support page.
            array(
                'description' => esc_html__('Create Clients Section', 'swap'),
                'panels_groups' => array('swap'),
                'help'        => '#',
            ),

            //The $control_options array, which is passed through to WP_Widget
            array(
            ),

            //The $form_options array, which describes the form fields used to configure SiteOrigin widgets. We'll explain these in more detail later.
            array(
                    'backgroundcolor' => array(
                    'type' => 'color',
                    'label' => esc_html__('Features Sub title', 'swap'),
                    'default' => '#ffffff'
                ),
 'subtitle' => array(
                    'type' => 'text',
                    'label' => esc_html__('Sub Title', 'swap'),
                    'default' => ''
                ),
               'title' => array(
                    'type' => 'text',
                    'label' => esc_html__('Title', 'swap'),
                    'default' => ''
                ),
                'clients_per_page' => array(
                            'type' => 'number',
                            'label' => esc_html__('Clients per page', 'swap'),
                            'default' => ''
                        ),
                'columns' => array(
                    'type' => 'select',
                    'label' => esc_html__( 'Number of columns per row', 'swap'),
                    'default' => '2',
                    'options' => array(
                        '1' => esc_html__( '1 Column', 'swap'),
                        '2' => esc_html__( '2 Column', 'swap'),
                        '3' => esc_html__( '3 Column', 'swap'),
                        '4' => esc_html__( '4 Column', 'swap'),
                        '5' => esc_html__( '5 Column', 'swap'),
                    )
                ),
               
               
              
            ),
            //The $base_folder path string.
            plugin_dir_path(__FILE__)
        );
    }

    function get_template_name($instance) {
        return 'clients';
    }

    function get_template_dir($instance) {
        return 'widgets';
    }
}

siteorigin_widget_register('clients_widget', __FILE__, 'clients_widget');

endif;